import { Component } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { RestaurantBase } from 'src/app/models/restaurant-base.model';
import { RestaurantService } from 'src/app/restaurant.service';

@Component({
  selector: 'app-restaurant-add',
  templateUrl: './restaurant-add.component.html',
  styleUrls: ['./restaurant-add.component.scss']
})
export class RestaurantAddComponent {
  // add map field
  readonly form = new FormGroup({
    name: new FormControl('', { validators: [Validators.required], nonNullable: true }),
    address: new FormControl('', { validators: [Validators.required], nonNullable: true }),
    phone: new FormControl('', { validators: [Validators.required], nonNullable: true }),
    description: new FormControl('', { validators: [Validators.required], nonNullable: true }),
    url: new FormControl(''),
  });

  constructor(private readonly restaurants: RestaurantService,
    private readonly router: Router) { }

  add() {
    this.restaurants.add(this.form.value as RestaurantBase).subscribe(() => {
      this.router.navigate(['restaurants']);
    });
  }
}
